﻿-- ===========================
-- Insert sample departments
-- ===========================
INSERT INTO departments (depname, manager)
VALUES 
    ('Human Resources', NULL),
    ('Engineering', NULL),
    ('Finance', NULL);

-- ===========================
-- Insert sample employees
-- ===========================
INSERT INTO employees (firstname, lastname, depid, salary, hiredate)
VALUES
    ('Alice', 'Johnson', 1, 4500.00, '2020-05-10'),
    ('Bob', 'Smith',     2, 5200.00, '2018-03-22'),
    ('Carol', 'Davis',   2, 6100.00, '2017-11-01'),
    ('David', 'Brown',   3, 4800.00, '2021-01-15');

-- After employees exist, update departments with a manager
UPDATE departments SET manager = 1 WHERE depid = 1; -- Alice
UPDATE departments SET manager = 2 WHERE depid = 2; -- Bob
UPDATE departments SET manager = 4 WHERE depid = 3; -- David

-- ===========================
-- Insert sample projects
-- ===========================
INSERT INTO projects (title, budget, startdate, enddate, progress)
VALUES 
    ('New Website',         30000.00, '2024-01-01', '2024-06-30', 45.0),
    ('Mobile App',          50000.00, '2024-02-15', '2024-10-15', 30.0),
    ('Accounting System',   40000.00, '2024-03-01', '2024-09-01', 60.0);

-- ===========================
-- Insert work assignments
-- ===========================
INSERT INTO workson (empid, proid)
VALUES
    (1, 1),  -- Alice → New Website
    (2, 1),  -- Bob → New Website
    (2, 2),  -- Bob → Mobile App
    (3, 2),  -- Carol → Mobile App
    (4, 3);  -- David → Accounting System
