-- ===========================
-- Create tables
-- ===========================

CREATE TABLE departments (
    depid INT IDENTITY(1,1) PRIMARY KEY,
    depname VARCHAR(50) NOT NULL,
    manager INT NULL     -- FK to employees, added later
);

CREATE TABLE employees (
    empid INT IDENTITY(1,1) PRIMARY KEY,
    firstname VARCHAR(50) NOT NULL,
    lastname VARCHAR(50) NOT NULL,
    depid INT NOT NULL,
    salary DECIMAL(6,2),
    hiredate DATE,
    CONSTRAINT fk_emp_dept
        FOREIGN KEY (depid) REFERENCES departments(depid)
);

-- Add manager FK (must be after employees exists)
ALTER TABLE departments
ADD CONSTRAINT fk_dept_manager
    FOREIGN KEY (manager) REFERENCES employees(empid);

CREATE TABLE projects (
    proid INT IDENTITY(1,1) PRIMARY KEY,
    title VARCHAR(120) NOT NULL,
    budget DECIMAL(9,2),
    startdate DATE,
    enddate DATE,
    progress DECIMAL(3,1)
);

CREATE TABLE workson (
    empid INT NOT NULL,
    proid INT NOT NULL,
    CONSTRAINT pk_workson PRIMARY KEY (empid, proid),
    CONSTRAINT fk_workson_emp FOREIGN KEY (empid)
        REFERENCES employees(empid),
    CONSTRAINT fk_workson_proj FOREIGN KEY (proid)
        REFERENCES projects(proid)
);
