library ieee;
use ieee.std_logic_1164.all;


-- Default VHDL example template for the VHDL DE10 board simulator
library ieee;
use ieee.std_logic_1164.all;
-- Add any other standard package you may need
-- use ieee.numeric_std.all; -- Uncomment if you use the unsigned type

-- Use this entity as a template for your own circuit. Do not change names or sizes
-- You can use unsigned instead of std_logic_vector, but you cannot use both at the same time in this entity
entity circuit is
port (
  clk500Hz: in std_logic; -- 50 Hz, period 20 ms
  key:     in std_logic_vector(3 downto 0);
  sw:      in std_logic_vector(9 downto 0);
  led:     out std_logic_vector(9 downto 0);
  hex0:    out std_logic_vector(6 downto 0);
  hex1:    out std_logic_vector(6 downto 0));
end circuit;

-- Modify the following architecture to implement your own circuit
architecture description of circuit is

begin

  led(9 downto 2) <= sw(9 downto 2);
 
  process(sw(1), sw(0))
  begin
  		if (sw(1) = '0' and sw(0) = '0') then
		  --FA <= '1';      FB <= '1';      FC <= '1';     FD <= '1';      FE <= '1';     FF <= '1';     FG <= '0';
			hex0(0) <= '0'; hex0(1) <= '0'; hex0(2)<= '0'; hex0(3) <= '0'; hex0(4)<= '0'; hex0(5)<= '0'; hex0(6)<= '1';
		elsif (sw(1) = '0' and sw(0) = '1') then 
		  --FA <= '0';      FB <= '1';      FC <= '1';     FD <= '0';      FE <= '0';     FF <= '0';     FG <= '0';
		    hex0(0) <= '1'; hex0(1) <= '0'; hex0(2)<= '0'; hex0(3) <= '1'; hex0(4)<= '1'; hex0(5)<= '1'; hex0(6)<= '1';
		elsif (sw(1) = '1' and sw(0) = '0') then 
		  --FA <= '1';      FB <= '1';      FC <= '0';     FD <= '1';      FE <= '1';     FF <= '0';     FG <= '1';
		    hex0(0) <= '0'; hex0(1) <= '0'; hex0(2)<= '1'; hex0(3) <= '0'; hex0(4)<= '0'; hex0(5)<= '1'; hex0(6)<= '0';
		else
		   --FA <= '1';      FB <= '1';      FC <= '1';     FD <= '1';      FE <= '0';     FF <= '0';     FG <= '1';		
			hex0 <= "0110000";
		end if;

  end process;
 
end architecture; 
  
