library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity multiplier is 
port(
	a: in std_logic_vector(3 downto 0);
    b: in std_logic_vector(2 downto 0);
	prod: out std_logic_vector(6 downto 0)
); 
end multiplier; 

architecture struct of multiplier is 
	
component binary_adder_4bit
port(
	a,b: in std_logic_vector(3 downto 0); 
	cin: in std_logic;
	sum: out std_logic_vector(3 downto 0); 
	cout: out std_logic
); 
end component;

component mult_1bit 
port(
	a: in std_logic_vector(3 downto 0); 
	b: in std_logic;
	mult: out std_logic_vector(3 downto 0) 
);
end component;

signal p0: std_logic_vector( 3 downto 0); 
signal p1: std_logic_vector( 3 downto 0);
signal p2: std_logic_vector( 3 downto 0);

signal s1: std_logic_vector( 3 downto 0);
signal c1: std_logic;
signal s2: std_logic_vector( 3 downto 0);
signal c2: std_logic;

signal p0s: std_logic_vector( 3 downto 0);
signal p1s: std_logic_vector( 3 downto 0);


begin 

m0: mult_1bit PORT MAP (a, b(0), p0);
m1: mult_1bit PORT MAP (a, b(1), p1);
m2: mult_1bit PORT MAP (a, b(2), p2);
p0s <= '0' & p0(3 downto 1);
add1 : binary_adder_4bit PORT MAP (p1, p0s, '0', s1, c1);
p1S <= c1 & s1(3 downto 1);
add2 : binary_adder_4bit PORT MAP (p2, p1s, '0', s2, c2);

prod(0) <= p0(0);
prod(1) <= s1(0);
prod(5 downto 2) <= s2;
prod(6) <= c2;

end struct; 


-- Declare 1 bit multiplier entity;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity mult_1bit is
port(
	a: in std_logic_vector(3 downto 0); 
	b: in std_logic;
	mult: out std_logic_vector(3 downto 0)
); 
end mult_1bit;

architecture mult_arch of mult_1bit is
begin
    mult(0) <= a(0) and b;
    mult(1) <= a(1) and b;
    mult(2) <= a(2) and b;
    mult(3) <= a(3) and b;
end mult_arch;
