LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY Testbench_half_adder IS
END Testbench_half_adder;

ARCHITECTURE behavior OF Testbench_half_adder IS

-- Component Declaration for the Unit Under Test (UUT)

COMPONENT half_adder PORT(
A : IN std_logic;
B : IN std_logic;
S : OUT std_logic;
C : OUT  std_logic);
END COMPONENT;



--Inputs
signal SA : std_logic := '0';
signal SB : std_logic := '0';
--Outputs
signal SSum : std_logic;
signal SCout : std_logic;

BEGIN
-- Instantiate the Unit Under Test (UUT)
uut: half_adder PORT MAP (
   		A => SA,
		B => SB,
		S  => SSum,
		C => SCout
);


-- Stimulus process
stim_proc: process
begin
-- hold reset state for 10 ns.
wait for 10 ns; 

-- insert stimulus here
SA <= '1';
SB <= '0';
wait for 10 ns;

SA <= '0';
SB <= '1';
wait for 10 ns;

SA <= '1';
SB <= '1';
wait for 10 ns;

SA <= '0';
SB <= '0';
wait for 10 ns;

SA <= '1';
SB <= '0';
wait for 10 ns;

SA <= '0';
SB <= '1';
wait for 10 ns;

SA <= '1';
SB <= '1';
wait for 10 ns;

 assert false report ("END OF TEST");
 wait;

end process;

END;

