library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Entity Declaration
entity full_adder is
port (
A, B, Ci : in bit; -- Inputs
S, Co: out bit -- Outputs
);
end full_adder;

-- Architecture Definition
architecture structural of full_adder is

-- Component Declaration for Half Adder
component half_adder is
port (
A, B : in bit;
S, C : out bit
);
end component;

-- Component Declaration for OR Gate
component or_gate is
port (
A, B : in bit;
Y : out bit
);
end component;

-- Internal Signals
signal T1, T2, T3 : bit;

begin

-- Instantiate First Half Adder
half_adder1: half_adder port map (
A => A, B => B, S => T1, C => T2
);

-- Instantiate Second Half Adder
half_adder2: half_adder port map (
A => T1, B => Ci, S => S, C => T3
);

-- Instantiate OR Gate for Final Carry-Out
or_gate1: or_gate port map (
A => T2,
B => T3,
Y => Co
);

end structural;
