LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY Testbench_full_adder IS
END Testbench_full_adder;

ARCHITECTURE behavior OF Testbench_full_adder IS

-- Component Declaration for the Unit Under Test (UUT)

COMPONENT full_adder_behave PORT(
A : IN bit;
B : IN bit;
Cin : IN bit;
Sum : OUT bit;
Cout : OUT  bit);
END COMPONENT;

COMPONENT full_adder_df PORT(
A : IN bit;
B : IN bit;
Cin : IN bit;
Sum : OUT bit;
Cout : OUT  bit);
END COMPONENT;

COMPONENT full_adder_str PORT(
A : IN bit;
B : IN bit;
Cin : IN bit;
Sum : OUT bit;
Cout : OUT  bit);
END COMPONENT;


--Inputs
signal SA : bit := '0';
signal SB : bit := '0';
signal SCin : bit := '0';
--Outputs
signal SSum1 : bit;
signal SCout1 : bit;

signal SSum2 : bit;
signal SCout2 : bit;

signal SSum3 : bit;
signal SCout3 : bit;

BEGIN
-- Instantiate the Unit Under Test (UUT)
uut1: full_adder_behave PORT MAP (
   		A => SA,
		B => SB,
		Cin => SCin,
		Sum  => SSum1,
		Cout => SCout1
);

uut2: full_adder_df PORT MAP (
	   	A => SA,
		B => SB,
		Cin => SCin,
		Sum  => SSum2,
		Cout => SCout2
);

uut3: full_adder_str PORT MAP (
	   	A => SA,
		B => SB,
		Cin => SCin,
		Sum  => SSum3,
		Cout => SCout3
);

-- Stimulus process
stim_proc: process
begin
-- hold reset state for 10 ns.
wait for 10 ns; 

-- insert stimulus here
SA <= '1';
SB <= '0';
SCin <= '0';
wait for 10 ns;

SA <= '0';
SB <= '1';
SCin <= '0';
wait for 10 ns;

SA <= '1';
SB <= '1';
SCin <= '0';
wait for 10 ns;

SA <= '0';
SB <= '0';
SCin <= '1';
wait for 10 ns;

SA <= '1';
SB <= '0';
SCin <= '1';
wait for 10 ns;

SA <= '0';
SB <= '1';
SCin <= '1';
wait for 10 ns;

SA <= '1';
SB <= '1';
SCin <= '1';
wait for 10 ns;

 assert false report ("END OF TEST");
 wait;

end process;

END;

