library ieee; 
use ieee.std_logic_1164.all;  

entity full_adder_str  is
	port (A : in bit;  
	      B : in bit;
          Cin : in bit;	
	      Sum : out   bit;
 	      Cout : out  bit);
end full_adder_str;

architecture  structural  of full_adder_str  is
component and2
port (I1,I2: in bit; O: out bit);
end component;

component  xor2
port (I1,I2: in bit; O: out bit);
end component;

component or3
port (I1,I2, I3: in bit; O: out bit);
end component;

signal  s1, s2, s3, s4 : bit;
begin
	u0 : xor2 port map (A,B,  s1);
	u1 : xor2 port map (s1,Cin, Sum);
	u2 : and2 port map (A,B,  s2);
	u3 : and2 port map (A,Cin,  s3);
	u4 : and2 port map (B,Cin,  s4);
	u5 : or3  port map (s2,s3,  s4, Cout);
end;

-- TWO INPUT XOR ENTITY
library ieee; 
use ieee.std_logic_1164.all;  
entity xor2 is port (
	I1,I2: in bit; O: out bit);
end  xor2;
architecture behave  of xor2  is
begin 
	O <=I1 xor I2;
end behave;

-- TWO INPUT AND ENTITY
library ieee; 
use ieee.std_logic_1164.all;  
entity and2 is port (
	I1,I2: in bit; O: out bit);
end  and2;
architecture behave  of and2  is
begin 
	O <=I1 and I2;
end behave;

--THREE INPUT OR ENTITY
library ieee; 
use ieee.std_logic_1164.all;  
Entity or3 is port (
	I1,I2, I3: in bit; O: out bit);
end  or3;

architecture behave  of or3  is
begin 
	O <=I1 or I2 or I3;
end behave;
