-- Default VHDL example template for the VHDL DE10 board simulator
library ieee;
use ieee.std_logic_1164.all;
-- Add any other standard package you may need
-- use ieee.numeric_std.all; -- Uncomment if you use the unsigned type

-- Use this entity as a template for your own circuit. Do not change names or sizes
-- You can use unsigned instead of std_logic_vector, but you cannot use both at the same time in this entity
entity circuit is
port (
  clk500Hz: in std_logic; -- 50 Hz, period 20 ms
  key:     in std_logic_vector(3 downto 0);
  sw:      in std_logic_vector(9 downto 0);
  led:     out std_logic_vector(9 downto 0);
  hex0:    out std_logic_vector(6 downto 0);
  hex1:    out std_logic_vector(6 downto 0));
end circuit;

-- Modify the following architecture to implement your own circuit
architecture description of circuit is

signal val: std_logic_vector(1 downto 0);


procedure full_adder_2(signal A,B,Ci: in std_logic;  
                       signal S, Co: out std_logic) is 

variable v: std_logic_vector(2 downto 0);

begin  
    v := A & B & Ci;
    case v is
      when "000"=>  S <='0'; Co<='0'; 
      when "001"=>  S <='1'; Co<='0';
      when "010"=>  S <='1'; Co<='0';
      when "011"=>  S <='0'; Co<='1';
      when "100"=>  S <='1'; Co<='0';
      when "101"=>  S <='0'; Co<='1';
      when "110"=>  S <='0'; Co<='1';
      when "111"=>  S <='1'; Co<='1';
      when others=> S <='X'; Co<='X';
    end case;
end full_adder_2;  


function  full_adder_1(A,B,Ci: std_logic) return std_logic_vector is
  variable v : std_logic_vector(2 downto 0);
  begin
    v := A & B & Ci;
    case v is
      when "000"=> return "00"; 
      when "001"=> return "01"; 
      when "010"=> return "01"; 
      when "011"=> return "10"; 
      when "100"=> return "01"; 
      when "101"=> return "10"; 
      when "110"=> return "10"; 
      when "111"=> return "11"; 
      when others=> return "XX"; 
    end case;
  end function;


begin
     
    val <= full_adder_1(sw(2), sw(1), sw(0));
	
    led(9) <= val(1);
    led(8) <= val(0);

    full_adder_2 (sw(2), sw(1), sw(0), led(6), led(7));


end architecture; 


