library ieee; 
use ieee.std_logic_1164.all;  
entity full_adder_behave  is
	port (A : in bit;  
	      B : in bit;
          Cin : in bit;	
	      Sum : out   bit;
 	      Cout : out  bit
	);
end full_adder_behave;

architecture  behavioral  of full_adder_behave  is
begin
process (A,B,Cin)
variable s: bit_vector(1 to 3); 
variable num: integer range 0 to 3 ; 

begin
        s  :=  A & B & Cin;
	num := 0;
	for i in 1 to 3 loop
		if s(i) = '1' then
			num := num + 1;
		end if;
	end loop;

	case num is 
		when 0=> Cout <='0'; Sum <='0';
		when 1=> Cout <='0'; Sum <='1';
		when 2=> Cout <='1'; Sum <='0';
		when 3=> Cout <='1'; Sum <='1';
	end case;
end process;
end;
