LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY Testbench_binary_adder IS
END Testbench_binary_adder;

ARCHITECTURE behavior OF Testbench_binary_adder IS

-- Component Declaration for the Unit Under Test (UUT)

COMPONENT binary_adder_4bit  PORT(
	a,b: in bit_vector(3 downto 0); 
    cin: in bit;
	sum: out bit_vector(3 downto 0); 
	cout: out bit); 
END COMPONENT; 


--Inputs
signal SA : bit_vector(3 downto 0) := "0000";
signal SB : bit_vector(3 downto 0) := "0000";
signal SCin : bit := '0';

--Outputs
signal SSum : bit_vector(3 downto 0);
signal SCout : bit;

BEGIN
-- Instantiate the Unit Under Test (UUT)
uut:  binary_adder_4bit PORT MAP (
   		A => SA,
		B => SB,
		Cin => SCin,
		Sum  => SSum,
		Cout => SCout
);

-- Stimulus process
stim_proc: process
begin
-- hold reset state for 10 ns.
wait for 10 ns; 

-- insert stimulus here
SA <= "1001";
SB <= "0110";
SCin <= '0';
wait for 10 ns;

SA <= "0110";
SB <= "0101";
SCin <= '1';
wait for 10 ns;

SA <= "0111";
SB <= "1010";
SCin <= '1';
wait for 10 ns;

 assert false report ("END OF TEST");
 wait;

end process;

END;

