library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity binary_adder_4bit is 
port(
	a,b: in bit_vector(3 downto 0); 
	cin: in bit;
	sum: out bit_vector(3 downto 0); 
	cout: out bit); 
end binary_adder_4bit; 

architecture struct of binary_adder_4bit is 

signal c : bit_vector(3 downto 0); 

--define procedure full_adder
procedure full_adder(signal FA,FB,Ci: in bit;  
                      signal S, Co: out bit) is 

variable v: bit_vector(2 downto 0);

begin  
    v := FA & FB & Ci;
    case v is
      when "000"=>  S <='0'; Co<='0'; 
      when "001"=>  S <='1'; Co<='0';
      when "010"=>  S <='1'; Co<='0';
      when "011"=>  S <='0'; Co<='1';
      when "100"=>  S <='1'; Co<='0';
      when "101"=>  S <='0'; Co<='1';
      when "110"=>  S <='0'; Co<='1';
      when "111"=>  S <='1'; Co<='1';
      when others=> S <='0'; Co<='0';
    end case;
end full_adder; 


begin 
	full_adder(a(0), b(0), cin , sum(0), c(0)); 
	full_adder(a(1), b(1), c(0), sum(1), c(1)); 
	full_adder(a(2), b(2), c(1), sum(2), c(2)); 
	full_adder(a(3), b(3), c(2), sum(3), cout); 
end struct; 
