-- Default VHDL example template for the VHDL DE10 board simulator
library ieee;
use ieee.std_logic_1164.all;
-- Add any other standard package you may need
-- use ieee.numeric_std.all; -- Uncomment if you use the unsigned type

-- Use this entity as a template for your own circuit. Do not change names or sizes
-- You can use unsigned instead of std_logic_vector, but you cannot use both at the same time in this entity
entity circuit is
port (
  clk500Hz: in std_logic; -- 50 Hz, period 20 ms
  key:     in std_logic_vector(3 downto 0);
  sw:      in std_logic_vector(9 downto 0);
  led:     out std_logic_vector(9 downto 0);
  hex0:    out std_logic_vector(6 downto 0);
  hex1:    out std_logic_vector(6 downto 0));
end circuit;

-- Modify the following architecture to implement your own circuit
architecture description of circuit is

signal c: std_logic_vector(2 downto 0);
signal SA: std_logic_vector(3 downto 0);
signal SB: std_logic_vector(3 downto 0);
signal Sum: std_logic_vector(3 downto 0);
signal Cout: std_logic;


function dec7seg(val: std_logic_vector(3 downto 0)) return std_logic_vector is
  begin
    case val is
      when "0000"=> return "1000000"; --0
      when "0001"=> return "1111001"; --1
      when "0010"=> return "0100100"; --2
      when "0011"=> return "0110000"; --3
      when "0100"=> return "0011001"; --4
      when "0101"=> return "0010010"; --5
      when "0110"=> return "0000010"; --6
      when "0111"=> return "1111000"; --7
      when "1000"=> return "0000000"; --8
      when "1001"=> return "0011000"; --9
      when "1010"=> return "0001000"; --A
      when "1011"=> return "0000011"; --B
      when "1100"=> return "1000110"; --C
      when "1101"=> return "0100001"; --D
      when "1110"=> return "0000110"; --E
      when "1111"=> return "0001110"; --F
      when others=> return "1111111"; ---
    end case;
  end function;


procedure full_adder( signal A,B,Ci: in std_logic;  
                      signal S, Co: out std_logic) is 

variable v: std_logic_vector(2 downto 0);

begin  
    v := A & B & Ci;
    case v is
      when "000"=>  S <='0'; Co<='0'; 
      when "001"=>  S <='1'; Co<='0';
      when "010"=>  S <='1'; Co<='0';
      when "011"=>  S <='0'; Co<='1';
      when "100"=>  S <='1'; Co<='0';
      when "101"=>  S <='0'; Co<='1';
      when "110"=>  S <='0'; Co<='1';
      when "111"=>  S <='1'; Co<='1';
      when others=> S <='X'; Co<='X';
    end case;
end full_adder;  


begin
  
	led(3 downto 0) <= Sum;
	led(4) <= Cout;
	SA <= sw(3 downto 0);
	SB <= sw(7 downto 4);
		
	
	full_adder (SA(0), SB(0), sw(9), Sum(0), c(0));
	full_adder (SA(1), SB(1), C(0), Sum(1), C(1));
	full_adder (SA(2), SB(2), C(1), Sum(2), C(2));
	full_adder (SA(3), SB(3), C(2), Sum(3), Cout);

	hex0 <= dec7seg(Sum);
	hex1 <= dec7seg("000"& Cout);
	


end description;



