-- Default VHDL example template for the VHDL DE10 board simulator
library ieee;
use ieee.std_logic_1164.all;
-- Add any other standard package you may need
-- use ieee.numeric_std.all; -- Uncomment if you use the unsigned type

-- Use this entity as a template for your own circuit. Do not change names or sizes
-- You can use unsigned instead of std_logic_vector, but you cannot use both at the same time in this entity
entity circuit is
port (
  clk500Hz: in std_logic; -- 50 Hz, period 20 ms
  key:     in std_logic_vector(3 downto 0);
  sw:      in std_logic_vector(9 downto 0);
  led:     out std_logic_vector(9 downto 0);
  hex0:    out std_logic_vector(6 downto 0);
  hex1:    out std_logic_vector(6 downto 0));
end circuit;

-- Modify the following architecture to implement your own circuit
architecture description of circuit is

--signal c: std_logic_vector(2 downto 0);
signal SA: std_logic_vector(3 downto 0);
signal SB: std_logic_vector(3 downto 0);
signal Sum: std_logic_vector(3 downto 0);
signal Cout: std_logic;


function dec7seg(val: std_logic_vector(3 downto 0)) return std_logic_vector is
  begin
    case val is
      when "0000"=> return "1000000"; --0
      when "0001"=> return "1111001"; --1
      when "0010"=> return "0100100"; --2
      when "0011"=> return "0110000"; --3
      when "0100"=> return "0011001"; --4
      when "0101"=> return "0010010"; --5
      when "0110"=> return "0000010"; --6
      when "0111"=> return "1111000"; --7
      when "1000"=> return "0000000"; --8
      when "1001"=> return "0011000"; --9
      when "1010"=> return "0001000"; --A
      when "1011"=> return "0000011"; --B
      when "1100"=> return "1000110"; --C
      when "1101"=> return "0100001"; --D
      when "1110"=> return "0000110"; --E
      when "1111"=> return "0001110"; --F
      when others=> return "1111111"; ---
    end case;
  end function;




Component binary_adder_4bit is 
port(
	a,b: in std_logic_vector(3 downto 0); 
	cin: in std_logic;
	sum: out std_logic_vector(3 downto 0); 
	cout: out std_logic); 
end component; 



begin

    BADDER : binary_adder_4bit PORT MAP(SA, SB, sw(9), Sum, Cout);

	led(3 downto 0) <= Sum;
	led(4) <= Cout;
	SA <= sw(3 downto 0);
	SB <= sw(7 downto 4);
		
	hex0 <= dec7seg(Sum);
	hex1 <= dec7seg("000"& Cout);
	


end description;




library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity binary_adder_4bit is 
port(
	a,b: in std_logic_vector(3 downto 0); 
	cin: in std_logic;
	sum: out std_logic_vector(3 downto 0); 
	cout: out std_logic); 
end binary_adder_4bit; 

architecture struct of binary_adder_4bit is 
	signal c : std_logic_vector(3 downto 0); 
	

component full_adder_df 
port(
	a,b,cin: in std_logic; 
	sum, cout: out std_logic); 
end component;
 
begin 
   
	FA0: full_adder_df port map(a(0), b(0), cin, sum(0), c(0)); 
	FA1: full_adder_df port map(a(1), b(1), c(0), sum(1), c(1)); 
	FA2: full_adder_df port map(a(2), b(2), c(1), sum(2), c(2)); 
	FA3: full_adder_df port map(a(3), b(3), c(2), sum(3), Cout); 
 end struct; 

 library ieee; 
use ieee.std_logic_1164.all;  


entity full_adder_df  is
port (A : in std_logic;  
	    B : in std_logic;
        Cin : in std_logic;	
	    Sum : out   std_logic;
 	    Cout : out  std_logic
	);
end full_adder_df;

architecture  behavioral  of full_adder_df  is
signal s1, s2, s3, s4 : std_logic;
begin
	s1 <= A xor B;
	Sum <= s1 xor Cin;
	s2 <= A and B;
	s3 <= A and Cin;
	s4 <= B and Cin;
	Cout <= s2 or s3 or s4;
end;



