library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity binary_adder_4bit is 
port(
	a,b: in bit_vector(3 downto 0); 
	cin: in bit;
	sum: out bit_vector(3 downto 0); 
	cout: out bit); 
end binary_adder_4bit; 

architecture struct of binary_adder_4bit is 
	signal c : bit_vector(3 downto 0); 
	

component full_adder_df 
port(
	a,b,cin: in bit; 
	sum, cout: out bit); 
end component;
 
begin 
   
	FA0: full_adder_df port map(a(0), b(0), cin, sum(0), c(0)); 
	FA1: full_adder_df port map(a(1), b(1), c(0), sum(1), c(1)); 
	FA2: full_adder_df port map(a(2), b(2), c(1), sum(2), c(2)); 
	FA3: full_adder_df port map(a(3), b(3), c(2), sum(3), Cout); 
 end struct; 
