// include the library code:
#include <Keypad.h>

const int HEATER=2, COOLER=5 ;
const int RED_LED=3, YELLOW_LED = 4;

const byte ROWS = 4;
const byte COLS = 3;
int Temperature;

char hexaKeys[ROWS][COLS] = {
  {'1', '2', '3'},
  {'4', '5', '6'},
  {'7', '8', '9'},
  {'*', '0', '#'}
};

byte rowPins[ROWS] = {13, 12, 11, 10};
byte colPins[COLS] = {9, 8, 7};

//initialize the keypad connection.
Keypad customKeypad = Keypad(makeKeymap(hexaKeys), rowPins, colPins, ROWS, COLS);



void setup() {
  pinMode(HEATER, OUTPUT);
  pinMode(COOLER, OUTPUT);

  pinMode(YELLOW_LED, OUTPUT);
  pinMode(RED_LED, OUTPUT);
  

  digitalWrite(HEATER, LOW);
  digitalWrite(COOLER, LOW);
 
  digitalWrite(YELLOW_LED, LOW);
  digitalWrite(RED_LED, LOW);
  
  
}

void loop() {

  char customKey = customKeypad.getKey();


  if (customKey){
    if (customKey == '1'){
      digitalWrite(HEATER, HIGH);
    }
    if (customKey == '4'){
      digitalWrite(HEATER, LOW);
    }
    if (customKey == '3'){
      analogWrite(COOLER, 190);
    }
    if (customKey == '6'){
      digitalWrite(COOLER, LOW);
    }
  }

  Temperature = analogRead(A0)/10;


  if (Temperature < 30) {
    digitalWrite(YELLOW_LED, HIGH);
    digitalWrite(RED_LED, LOW);
  }
  else if (Temperature > 40) {
    digitalWrite(RED_LED, HIGH);
    digitalWrite(YELLOW_LED, LOW);
  }
  else {
    digitalWrite(RED_LED, LOW);
    digitalWrite(YELLOW_LED, LOW);
  }
}