
// include the library code:
#include <LiquidCrystal.h>
#include <Keypad.h>

// initialize the library by associating any needed LCD interface pin
// with the arduino pin number it is connected to
const int rs = 13, en = 12, d4=8, d5=9, d6 =10, d7 = 11;
LiquidCrystal lcd(rs, en, d4, d5, d6, d7);


const byte ROWS = 4; 
const byte COLS = 4; 

char hexaKeys[ROWS][COLS] = {
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};

byte rowPins[ROWS] = {7, 6, 5, 4}; 
byte colPins[COLS] = {A0,A1,A2,A3}; 

Keypad customKeypad = Keypad(makeKeymap(hexaKeys), 
rowPins, colPins, ROWS, COLS); 

int count;
//initialize the keypad connection.

void setup() {
  // set up the LCD's number of columns and rows:
  lcd.begin(16, 2);

  lcd.setCursor(3,0);
  // Print a message to the LCD.
  lcd.print("Asimopoulos");
  count = 0;

  Serial.begin(9600);

}

void loop() {
  char customKey = customKeypad.getKey();
  char my_char;
  
  if (customKey){
    // set the cursor to column 0, line 1
    // (note: line 1 is the second row, since counting begins with 0):
    lcd.setCursor(count, 1);
    lcd.print(customKey);

    Serial.print(customKey); 
    count++;
  } 

  if (Serial.available()){
      my_char = Serial.read();
      delay(10);
      lcd.print(my_char);
      Serial.print(my_char);
      count++;
  } 

  /*
  do {

      Serial.print("a");
      delay(1);

  } while(1);
  */

    
}
