
#include <Wire.h>

#define EEPROM_ID 0xA0 >> 1 
#define DS1621_ID 0x90 >> 1 
#define DS1307_ID 0xD0 >> 1 
   

void setup() {
  int i;


  Serial.begin(9600);
  Wire.begin(); // join i2c bus (address optional for master)
  
  Wire.beginTransmission(EEPROM_ID); // transmit to device 24c04
  Wire.write(0);
  for (i=0; i<30; i++)
  {
    Wire.write(0xFF);
  }
  Wire.endTransmission();    // stop transmitting
  
  //setup temperature sensor

  Wire.beginTransmission(DS1621_ID);             // connect to DS1621 (#0)
  Wire.write(0xAC);                            // Access Config
  Wire.write(0x02);                            // set for continuous conversion
  Wire.beginTransmission(DS1621_ID);             // restart    Wire.write(0xEE);                            // start conversions
  Wire.endTransmission();
  
}
/*
byte seconds, minutes, hour, day, date, month, year;
byte x;
*/


void loop() {
  /*
  Serial.print("Starting main loop\n");
  Serial.print("Writing to EEPROM\n");
  */
  /*
  do {
  Wire.beginTransmission(EEPROM_ID); // transmit to device #A0>>1
  Wire.write(0);                // specifies starting memory byte
  Wire.endTransmission();    // stop transmitting
  }while(1);
  */
  /*
  delay(1000);
  */
  Serial.print("Writing data to EEPROM\n");
  Wire.beginTransmission(EEPROM_ID); // transmit to device #A0>>1
  Wire.write(16);                // specifies starting memory byte
  Wire.write('N');              // sends one byte
  Wire.write('I');              // sends one byte
  Wire.write('K');              // sends one byte
  Wire.write('O');              // sends one byte
  Wire.write('S');              // sends one byte
  Wire.endTransmission();    // stop transmitting



  Wire.beginTransmission(EEPROM_ID); // transmit to device #A0>>1
  Wire.write(0);                // specifies starting memory byte
  Wire.write("nikos");              // sends one byte
  Wire.endTransmission();    // stop transmitting

  delay(1000);
  
  Serial.print("\nReading temperature from DS1621 at address 0x90\n");  

  int8_t firstByte;
  int8_t secondByte;
  float temp = 0;
  int8_t  seconds,minutes,hour,day,date,month,year;
  int8_t x;

  delay(1000);                                // give time for measurement

  Wire.beginTransmission(DS1621_ID);
  Wire.write(0xAA);                            // read temperature command
  Wire.endTransmission();
  Wire.requestFrom(DS1621_ID, 2);    // request two bytes from DS1621 (0.5 deg. resolution)

  firstByte = Wire.read();           // get first byte
  secondByte = Wire.read();    // get second byte

  temp = firstByte;

  if (secondByte)             // if there is a 0.5 deg difference
        temp += 0.5;

  Serial.println(temp);
  delay(1000);
  /*
  delay(500);
 

  
  */
  Serial.print("\nReading time from RTC DS1307 at address D0..\n");
  
  Wire.beginTransmission(DS1307_ID); // transmit to device D0>>1
  Wire.write(0);                // specifies starting memory byte
  Wire.endTransmission();       // stop transmitting
 
  x = Wire.requestFrom(DS1307_ID,7); // transmit to device #D0>>1
  if (x != 7) Serial.print("error reading from RTC\n");
  
  seconds = Wire.read();     // reads one byte
  minutes = Wire.read();
  hour    = Wire.read();
  day     = Wire.read();
  date    = Wire.read();
  month   = Wire.read();
  year    = Wire.read();
  Wire.endTransmission();    // stop transmitting


  Serial.write(seconds);
  Serial.write(minutes);
  Serial.write(hour);
  Serial.write(day);
  Serial.write(date);
  Serial.write(month);
  Serial.write(year);

  delay(1000);
  
  Serial.write("\n");

  Serial.write(((seconds & 0x7F)>>4) +0x30);
  Serial.write((seconds & 0x0F) + 0x30);
  Serial.write(" Seconds\n");
  
  Serial.write(((minutes & 0x7F)>>4) +0x30);
  Serial.write((minutes & 0x0F) + 0x30);
  Serial.write(" Minutes\n");

  Serial.write(((hour & 0x3F)>>4) +0x30);
  Serial.write((hour & 0x0F) + 0x30);
  Serial.write(" hours\n");
  
  delay(1000);
  exit(0);
  
}
