// include the library code:
#include <Keypad.h>

const int SEGA = 6, SEGB = 5, SEGC =4, SEGD=3, SEGE = 2, SEGF = 1,SEGG = 0;

const byte ROWS = 4;
const byte COLS = 3;

char hexaKeys[ROWS][COLS] = {
  {'1', '2', '3'},
  {'4', '5', '6'},
  {'7', '8', '9'},
  {'*', '0', '#'}
};

byte rowPins[ROWS] = {13, 12, 11, 10};
byte colPins[COLS] = {9, 8, 7};

//initialize the keypad connection.
Keypad customKeypad = Keypad(makeKeymap(hexaKeys), rowPins, colPins, ROWS, COLS);


void write_to_HEX(int a, int b, int c, int d, int e, int f, int g)
{
  digitalWrite(SEGA, a);
  digitalWrite(SEGB, b);
  digitalWrite(SEGC, c);
  digitalWrite(SEGD, d);
  digitalWrite(SEGE, e);
  digitalWrite(SEGF, f);
  digitalWrite(SEGG, g);
}

void setup() {
  pinMode(SEGA, OUTPUT);
  pinMode(SEGB, OUTPUT);
  pinMode(SEGC, OUTPUT);
  pinMode(SEGD, OUTPUT);
  pinMode(SEGE, OUTPUT);
  pinMode(SEGF, OUTPUT);
  pinMode(SEGG, OUTPUT);
}

void loop() {

  char customKey = customKeypad.getKey();

  if (customKey){
    if (customKey == '0'){
      write_to_HEX(1,1,1,1,1,1,0);
    }
    else if (customKey == '1'){
      write_to_HEX(0,1,1,0,0,0,0);
    }
    else {
      write_to_HEX(1,0,0,0,1,1,1);
    }
  }
}
