#include<LiquidCrystal.h>            //LCD display library

#define ledPin 13

LiquidCrystal lcd(7,8,9,10,11,12);


volatile unsigned value = 500;                   //Preload timer value (3035 for 4 seconds)


void setup()

{

  int text;
  lcd.begin(16,2);
  lcd.setCursor(0,0);
  lcd.print("ARDUINO TIMERS");

  delay(2000);
  
  lcd.clear();

  pinMode(ledPin, OUTPUT);
  pinMode(2,INPUT);
  pinMode(3,INPUT);


  noInterrupts();                       // disable all interrupts
  
  TCCR1A = 0;
  TCCR1B = 0;

  TCNT1 = value;                        // preload timer
  TCCR1B |= (1 << CS10)|(1 << CS12);    // 1024 prescaler 
  TIMSK1 |= (1 << TOIE1);               // enable timer overflow interrupt ISR


  text = TIMSK1;
  lcd.setCursor(7,1);
  lcd.print(text);

  delay(1000);

  interrupts();                         // enable all interrupts

}


ISR(TIMER1_OVF_vect)                    // interrupt service routine for overflow
{
  TCNT1 = value;                                // preload timer
  digitalWrite(ledPin, digitalRead(ledPin) ^ 1);  //Turns LED ON and OFF
}


void loop()
{
  if(digitalRead(2) == HIGH)
  {
    value = value+10;
    if (value>= 30000) value = 30000;   //Incement preload value
  }
  if(digitalRead(3)== HIGH)
  {
    value = value-10; 
    if (value <= 20) value = 20; //Decrement preload value
  }
  lcd.setCursor(0,0);
  if (value<10000) lcd.print(0);
  if (value<1000) lcd.print(0);
  if (value<100) lcd.print(0);
  if (value<10) lcd.print(0);
  
  lcd.print(value);
  
}
