//Interrupts using Arduino
//Circuit Digest


#include<LiquidCrystal.h>                        // Including lcd display library
LiquidCrystal lcd (7,8,9,10,11,12);              // Define LCD display pins RS,E,D4,D5,D6,D7
//rs, en, d4, d5, d6, d7

int ledPin1 = 13;
int ledPin2 = 1;
int ledPin3 = 4;

int intPin1 = 2;
int intPin2 = 3;


volatile byte output1 = HIGH; 
volatile byte output2 = HIGH;                    

unsigned int i = 0;   
volatile unsigned value = 60000;

void setup()                                                     
{

  //int TimerReg;
  
  lcd.begin(16,2);                              //  setting LCD as 16x2 type
  lcd.setCursor(0,0);
  lcd.print("NIKOS 1234");                                    

  
  noInterrupts();                       // disable all interrupts
  
  TCCR1A = 0;
  TCCR1B = 0;

  TCNT1 = value;                        // preload timer
  TCCR1B |= (1 << CS10)|(1 << CS12);    // 1024 prescaler 
  TIMSK1 |= (1 << TOIE1);               // enable timer overflow interrupt ISR
  

  /*
  TCCR1A = 0;
  TCCR1B = 0; 
  OCR1A = value;
  TCCR1B = (1<<WGM12) | (1<<CS12); 
  TIMSK1 = (1<<OCIE1A); 
  //interrupts();
  */
  /*
  TimerReg = TIMSK1;
  lcd.setCursor(14,1);
  lcd.print(TimerReg,HEX);

  delay(1000);  
  */
  
  pinMode(ledPin3,OUTPUT); 
  pinMode(ledPin1,OUTPUT);
  pinMode(ledPin2,OUTPUT);                                        
  
  
  attachInterrupt(digitalPinToInterrupt(intPin1),buttonPressed1,RISING);  //  function for creating external interrupts at pin2 on Rising (LOW to HIGH)
  attachInterrupt(digitalPinToInterrupt(intPin2),buttonPressed2,RISING);  //  function for creating external interrupts at pin3 on Rising (LOW to HIGH)  

  interrupts(); 
  

   lcd.clear();                                                   
   lcd.print("COUNTER:"); 
  
}


void loop()                                                      
{  

   lcd.setCursor(7,1);                                          
   lcd.print(i);                                                  
   if(i<500) i++;
   else (i=0);                                                            



    
   digitalWrite(ledPin1,output1);     //Turns LED ON or OFF depending upon output value
   digitalWrite(ledPin2,output2);     //Turns LED ON or OFF depending upon output value

}



ISR(TIMER1_OVF_vect)                    // interrupt service routine for overflow
{
  TCNT1 = value;                                // preload timer
  digitalWrite(ledPin3, digitalRead(ledPin3) ^ 1);  //Turns LED ON and OFF
}


void buttonPressed1()           //ISR function excutes when push button at pinD2 is pressed
{                    
   output1 = HIGH;     //Change Output value  
   output2 = LOW;                              
  
}


void buttonPressed2()           //ISR function excutes when push button at pinD3 is pressed                             
{                    
   output2 = HIGH;              //Change Output2  
   output1 = LOW;                                  
  
}
