//Interrupts using Arduino
//Circuit Digest


#include<LiquidCrystal.h>                        // Including lcd display library
LiquidCrystal lcd (7,8,9,10,11,12);              // Define LCD display pins RS,E,D4,D5,D6,D7


volatile byte output1 = LOW; 
volatile byte output2 = HIGH;                    
int i = 0;   


void setup()                                                     
{
  lcd.begin(16,2);                              //  setting LCD as 16x2 type
  lcd.setCursor(0,0);
  lcd.print("NIKOS 1234");                                    

  lcd.setCursor(0,1);
  lcd.print("ArduinoInterrupt");
  delay(3000);                                                     
  lcd.clear();                                                    

  pinMode(13,OUTPUT);
  pinMode(1, OUTPUT);                                        
  attachInterrupt(digitalPinToInterrupt(2),buttonPressed1,RISING);  //  function for creating external interrupts at pin2 on Rising (LOW to HIGH)
  attachInterrupt(digitalPinToInterrupt(3),buttonPressed2,RISING);  //  function for creating external interrupts at pin3 on Rising (LOW to HIGH)   
}


void loop()                                                      
{  

   lcd.clear();                                                   
   lcd.print("COUNTER:");                                           
   lcd.print(i);                                                  
   ++i;                                                            

   delay(200);   
   digitalWrite(13,output1);     //Turns LED ON or OFF depending upon output value
   digitalWrite(1,output2);     //Turns LED ON or OFF depending upon output value

}


void buttonPressed1()           //ISR function excutes when push button at pinD2 is pressed
{                    
   output1 = HIGH;     //Change Output value  
   output2 = LOW;                              
   lcd.setCursor(0,1);                                          
   lcd.print("Interrupt 1");
}


void buttonPressed2()           //ISR function excutes when push button at pinD3 is pressed                             
{                    
   
   output2 = HIGH;              //Change Output2  
   output1 = LOW;                                  
   lcd.setCursor(0,1);                                          
   lcd.print("Interrupt 2");
}
